function Navbar() {
    try {
        return (
            <nav data-name="navbar" className="fixed w-full z-50 glass-effect">
                <div className="container mx-auto px-6 py-4">
                    <div className="flex items-center justify-between">
                        <div data-name="logo" className="flex items-center hover-scale">
                            <i className="fas fa-play-circle text-3xl gradient-text mr-2"></i>
                            <span className="text-2xl font-bold gradient-text">WatchZone</span>
                        </div>
                        <div data-name="nav-links" className="hidden md:flex items-center space-x-8">
                            <a href="#features" className="text-gray-300 hover:text-white transition-colors">Features</a>
                            <a href="#download" className="text-gray-300 hover:text-white transition-colors">Download</a>
                            <a href="https://techcodebreaker.xyz" target="_blank" rel="noopener noreferrer" 
                               className="btn-primary px-6 py-2 rounded-full text-white font-semibold">
                                Visit Website
                            </a>
                        </div>
                    </div>
                </div>
            </nav>
        );
    } catch (error) {
        console.error('Navbar error:', error);
        reportError(error);
        return null;
    }
}
