function DownloadSection() {
    try {
        return (
            <section data-name="download" id="download" className="py-20 glass-effect">
                <div className="container mx-auto px-6 text-center">
                    <h2 className="text-3xl md:text-4xl font-bold mb-6">
                        Download <span className="gradient-text">WatchZone</span> Now
                    </h2>
                    <p className="text-gray-400 text-lg mb-8 max-w-2xl mx-auto">
                        Join millions of users who are already enjoying premium content on WatchZone. Download now and get 30 days free premium access!
                    </p>
                    <div data-name="download-button" className="inline-block">
                        <a href="https://thestrugg7dx.site/WatchZone2.0.apk" target="_blank" rel="noopener noreferrer" 
                           className="btn-primary px-8 py-4 rounded-full text-white font-semibold flex items-center hover-scale pulse-animation">
                            <i className="fab fa-google-play mr-2"></i>
                            Download Now
                        </a>
                    </div>
                </div>
            </section>
        );
    } catch (error) {
        console.error('Download section error:', error);
        reportError(error);
        return null;
    }
}
