import React from 'react';
import { Youtube, Instagram, Send, MessageCircle, Github } from 'lucide-react';

interface SocialButtonProps {
  href: string;
  icon: React.ReactNode;
  label: string;
  color: string;
}

const SocialButton: React.FC<SocialButtonProps> = ({ href, icon, label, color }) => (
  <a
    href={href}
    target="_blank"
    rel="noopener noreferrer"
    className={`${color} p-1.5 rounded-full hover:opacity-80 transition-opacity flex items-center justify-center group relative`}
    aria-label={label}
  >
    <span className="w-6 h-6 sm:w-8 sm:h-8 flex items-center justify-center text-white">
      {icon}
    </span>
    <span className="absolute -bottom-8 scale-0 transition-all rounded bg-gray-800 p-2 text-xs text-white group-hover:scale-100">
      {label}
    </span>
  </a>
);

const SocialButtons: React.FC = () => {
  return (
    <div className="flex justify-center gap-3 mb-8">
      <SocialButton
        href="https://www.youtube.com/@techcodebreaker"
        icon={<Youtube className="w-4 h-4 sm:w-5 sm:h-5" />}
        label="YouTube"
        color="bg-red-600"
      />
      <SocialButton
        href="https://whatsapp.com/channel/0029VaAbN12AInPku0aBiG2L"
        icon={<MessageCircle className="w-4 h-4 sm:w-5 sm:h-5" />}
        label="WhatsApp"
        color="bg-green-500"
      />
      <SocialButton
        href="https://www.instagram.com/dilshad_bhai47?igsh=MWxmbm41anhmNjZxdQ=="
        icon={<Instagram className="w-4 h-4 sm:w-5 sm:h-5" />}
        label="Instagram"
        color="bg-pink-600"
      />
      <SocialButton
        href="https://wa.link/mf77kf"
        icon={<Send className="w-4 h-4 sm:w-5 sm:h-5" />}
        label="Telegram"
        color="bg-blue-500"
      />
      <SocialButton
        href="https://github.com/iptv-org/iptv?tab=readme-ov-file#playlists"
        icon={<Github className="w-4 h-4 sm:w-5 sm:h-5" />}
        label="GitHub"
        color="bg-gray-700"
      />
    </div>
  );
};

export default SocialButtons;