import React from 'react';
import { Play } from 'lucide-react';
import type { Channel } from '../utils/m3uParser';

interface ChannelListProps {
  channels: Channel[];
  onChannelSelect: (channel: Channel) => void;
  selectedChannel?: Channel;
}

const ChannelList: React.FC<ChannelListProps> = ({ 
  channels, 
  onChannelSelect,
  selectedChannel 
}) => {
  return (
    <div className="bg-gray-800 rounded-lg overflow-hidden">
      <div className="p-3 sm:p-4 border-b border-gray-700">
        <h2 className="text-base sm:text-lg font-semibold text-white">Available Channels</h2>
        <p className="text-xs sm:text-sm text-gray-400">{channels.length} channels found</p>
      </div>
      <div className="divide-y divide-gray-700 max-h-[50vh] lg:max-h-[60vh] overflow-y-auto channel-list">
        {channels.map((channel, index) => (
          <button
            key={index}
            onClick={() => onChannelSelect(channel)}
            className={`w-full px-3 sm:px-4 py-2 sm:py-3 text-left hover:bg-gray-700/50 flex items-center justify-between transition-colors ${
              selectedChannel?.url === channel.url ? 'bg-gray-700' : ''
            }`}
          >
            <span className="text-sm sm:text-base text-white truncate pr-2">{channel.title}</span>
            <Play className={`w-4 h-4 sm:w-5 sm:h-5 flex-shrink-0 ${
              selectedChannel?.url === channel.url ? 'text-blue-400' : 'text-gray-400'
            }`} />
          </button>
        ))}
      </div>
    </div>
  );
}

export default ChannelList;