<?php
require_once 'includes/init.php';

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['playlist_url'])) {
    try {
        $url = filter_input(INPUT_POST, 'playlist_url', FILTER_SANITIZE_URL);
        
        if (!$url) {
            throw new Exception('Invalid URL format');
        }
        
        $channels = parseM3UFile($url);
        
        if (empty($channels)) {
            throw new Exception('No channels found in playlist');
        }
        
        $_SESSION['channels'] = $channels;
        $_SESSION['playlist_url'] = $url;
    } catch (Exception $e) {
        $_SESSION['error'] = $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>M3U Stream Player</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/hls.js@latest"></script>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body class="min-h-screen bg-gray-900 p-4 sm:p-6 md:p-8">
    <div class="max-w-6xl mx-auto">
        <!-- Header -->
        <div class="text-center mb-8">
            <h1 class="text-3xl md:text-4xl lg:text-5xl font-bold text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-purple-500 mb-6">
                TechCodeBreakerYT
            </h1>
            
            <!-- Social Links -->
            <div class="flex justify-center gap-3 mb-8">
                <a href="https://www.youtube.com/@techcodebreaker" target="_blank" class="bg-red-600 p-2 rounded-full hover:opacity-80 transition">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M22.54 6.42a2.78 2.78 0 0 0-1.94-2C18.88 4 12 4 12 4s-6.88 0-8.6.46a2.78 2.78 0 0 0-1.94 2A29 29 0 0 0 1 11.75a29 29 0 0 0 .46 5.33A2.78 2.78 0 0 0 3.4 19c1.72.46 8.6.46 8.6.46s6.88 0 8.6-.46a2.78 2.78 0 0 0 1.94-2 29 29 0 0 0 .46-5.25 29 29 0 0 0-.46-5.33z"></path><polygon points="9.75 15.02 15.5 11.75 9.75 8.48 9.75 15.02"></polygon></svg>
                </a>
                <a href="https://whatsapp.com/channel/0029VaAbN12AInPku0aBiG2L" target="_blank" class="bg-green-500 p-2 rounded-full hover:opacity-80 transition">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M21 11.5a8.38 8.38 0 0 1-.9 3.8 8.5 8.5 0 0 1-7.6 4.7 8.38 8.38 0 0 1-3.8-.9L3 21l1.9-5.7a8.38 8.38 0 0 1-.9-3.8 8.5 8.5 0 0 1 4.7-7.6 8.38 8.38 0 0 1 3.8-.9h.5a8.48 8.48 0 0 1 8 8v.5z"></path></svg>
                </a>
                <a href="https://www.instagram.com/dilshad_bhai47" target="_blank" class="bg-pink-600 p-2 rounded-full hover:opacity-80 transition">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><rect width="20" height="20" x="2" y="2" rx="5" ry="5"></rect><path d="M16 11.37A4 4 0 1 1 12.63 8 4 4 0 0 1 16 11.37z"></path><line x1="17.5" y1="6.5" x2="17.51" y2="6.5"></line></svg>
                </a>
                <a href="https://wa.link/mf77kf" target="_blank" class="bg-blue-500 p-2 rounded-full hover:opacity-80 transition">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><line x1="22" y1="2" x2="11" y2="13"></line><polygon points="22 2 15 22 11 13 2 9 22 2"></polygon></svg>
                </a>
                <a href="https://github.com/iptv-org/iptv?tab=readme-ov-file#playlists" target="_blank" class="bg-gray-700 p-2 rounded-full hover:opacity-80 transition">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path d="M9 19c-5 1.5-5-2.5-7-3m14 6v-3.87a3.37 3.37 0 0 0-.94-2.61c3.14-.35 6.44-1.54 6.44-7A5.44 5.44 0 0 0 20 4.77 5.07 5.07 0 0 0 19.91 1S18.73.65 16 2.48a13.38 13.38 0 0 0-7 0C6.27.65 5.09 1 5.09 1A5.07 5.07 0 0 0 5 4.77a5.44 5.44 0 0 0-1.5 3.78c0 5.42 3.3 6.61 6.44 7A3.37 3.37 0 0 0 9 18.13V22"></path></svg>
                </a>
                <!-- Play Store Icon -->
                <a href="YOUR_PLAY_STORE_LINK_HERE" target="_blank" class="bg-green-600 p-2 rounded-full hover:opacity-80 transition group relative">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path d="M3 3v18l8-3.5V6.5L3 3z"></path>
                        <path d="M3 3l8 5 9-4.5L11 0 3 3z"></path>
                        <path d="M11 8l9-4.5V18l-9 4.5V8z"></path>
                        <path d="M11 8l9 5v5l-9-5V8z"></path>
                    </svg>
                    <span class="absolute -bottom-8 scale-0 transition-all rounded bg-gray-800 p-2 text-xs text-white group-hover:scale-100">
                        Download App
                    </span>
                </a>
            </div>
        </div>

        <!-- Rest of the content remains the same -->
        <form method="POST" class="mb-8">
            <div class="flex gap-4">
                <input 
                    type="url" 
                    name="playlist_url"
                    placeholder="Enter M3U playlist URL..." 
                    class="flex-1 px-4 py-2 rounded-lg bg-gray-800 text-white border border-gray-700 focus:outline-none focus:border-blue-500"
                    required
                >
                <button type="submit" class="px-6 py-2 bg-blue-500 text-white rounded-lg hover:bg-blue-600 transition">
                    Load Playlist
                </button>
            </div>
        </form>

        <?php if (isset($_SESSION['error'])): ?>
            <div class="mb-8 p-4 bg-red-500/10 border border-red-500/20 rounded-lg text-red-400">
                <?php 
                echo htmlspecialchars($_SESSION['error']); 
                unset($_SESSION['error']);
                ?>
            </div>
        <?php endif; ?>

        <div class="grid grid-cols-1 lg:grid-cols-[1fr,400px] gap-8">
            <div id="player-container">
                <?php include 'includes/video_player.php'; ?>
            </div>
            
            <div class="channel-list">
                <?php include 'includes/channel_list.php'; ?>
            </div>
        </div>
    </div>

    <script src="assets/js/player.js"></script>
</body>
</html>