<?php if (isset($_GET['channel']) && isset($_SESSION['channels'])): 
    $channelIndex = (int)$_GET['channel'];
    $channel = $_SESSION['channels'][$channelIndex] ?? null;
?>
    <?php if ($channel): ?>
    <div class="relative">
        <video
            id="video-player"
            class="w-full aspect-video rounded-lg shadow-lg bg-black"
            data-src="<?php echo sanitizeOutput($channel['url']); ?>"
            playsinline
        ></video>
        
        <div class="absolute bottom-0 left-0 right-0 p-4 bg-gradient-to-t from-black/70 to-transparent">
            <div class="flex items-center justify-between text-white">
                <button id="play-pause" class="p-2 hover:bg-white/20 rounded-full transition">
                    <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polygon points="5 3 19 12 5 21 5 3"></polygon></svg>
                </button>
                
                <div class="flex items-center gap-4">
                    <button id="mute-unmute" class="p-2 hover:bg-white/20 rounded-full transition">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polygon points="11 5 6 9 2 9 2 15 6 15 11 19 11 5"></polygon><path d="M19.07 4.93a10 10 0 0 1 0 14.14M15.54 8.46a5 5 0 0 1 0 7.07"></path></svg>
                    </button>
                    
                    <button id="fullscreen" class="p-2 hover:bg-white/20 rounded-full transition">
                        <svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M8 3H5a2 2 0 0 0-2 2v3m18 0V5a2 2 0 0 0-2-2h-3m0 18h3a2 2 0 0 0 2-2v-3M3 16v3a2 2 0 0 0 2 2h3"></path></svg>
                    </button>
                </div>
            </div>
        </div>
    </div>
    <?php else: ?>
    <div class="aspect-video bg-gray-800 rounded-lg flex items-center justify-center text-gray-400">
        <p>Invalid channel selected</p>
    </div>
    <?php endif; ?>
<?php else: ?>
<div class="aspect-video bg-gray-800 rounded-lg flex items-center justify-center text-gray-400">
    <p>Select a channel to start watching</p>
</div>
<?php endif; ?>