<?php
require_once 'init.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['playlist_url'])) {
    try {
        $url = filter_input(INPUT_POST, 'playlist_url', FILTER_SANITIZE_URL);
        
        if (!$url) {
            throw new Exception('Invalid URL format');
        }
        
        $channels = parseM3UFile($url);
        
        if (empty($channels)) {
            throw new Exception('No channels found in playlist');
        }
        
        $_SESSION['channels'] = $channels;
        $_SESSION['playlist_url'] = $url;
        
        header('Location: ../index.php');
        exit;
    } catch (Exception $e) {
        $_SESSION['error'] = $e->getMessage();
        header('Location: ../index.php');
        exit;
    }
}

header('Location: ../index.php');
exit;