<?php if (!empty($_SESSION['channels'])): ?>
<div class="bg-gray-800 rounded-lg overflow-hidden">
    <div class="p-4 border-b border-gray-700">
        <h2 class="text-lg font-semibold text-white">Available Channels</h2>
        <p class="text-sm text-gray-400"><?php echo count($_SESSION['channels']); ?> channels found</p>
    </div>
    
    <div class="divide-y divide-gray-700 max-h-[60vh] overflow-y-auto">
        <?php foreach ($_SESSION['channels'] as $index => $channel): ?>
        <a 
            href="?channel=<?php echo $index; ?>"
            class="block px-4 py-3 text-left hover:bg-gray-700/50 flex items-center justify-between <?php echo isset($_GET['channel']) && (int)$_GET['channel'] === $index ? 'bg-gray-700' : ''; ?>"
        >
            <span class="text-white truncate"><?php echo sanitizeOutput($channel['title']); ?></span>
            <svg xmlns="http://www.w3.org/2000/svg" class="w-5 h-5 <?php echo isset($_GET['channel']) && (int)$_GET['channel'] === $index ? 'text-blue-400' : 'text-gray-400'; ?>" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polygon points="5 3 19 12 5 21 5 3"></polygon></svg>
        </a>
        <?php endforeach; ?>
    </div>
</div>
<?php endif; ?>