document.addEventListener('DOMContentLoaded', function() {
    const video = document.getElementById('video-player');
    if (!video) return;

    const playPauseBtn = document.getElementById('play-pause');
    const muteUnmuteBtn = document.getElementById('mute-unmute');
    const fullscreenBtn = document.getElementById('fullscreen');
    
    let hls = null;

    function initializePlayer() {
        const videoSrc = video.dataset.src;
        if (!videoSrc) return;

        if (videoSrc.includes('.m3u8') && Hls.isSupported()) {
            hls = new Hls({
                enableWorker: true,
                lowLatencyMode: true,
            });
            
            hls.loadSource(videoSrc);
            hls.attachMedia(video);
            
            hls.on(Hls.Events.MANIFEST_PARSED, function() {
                video.play().catch(function(error) {
                    console.log("Play failed:", error);
                });
            });
            
            hls.on(Hls.Events.ERROR, function(event, data) {
                if (data.fatal) {
                    console.error('HLS error:', data);
                    switch(data.type) {
                        case Hls.ErrorTypes.NETWORK_ERROR:
                            console.error('Network error');
                            break;
                        case Hls.ErrorTypes.MEDIA_ERROR:
                            console.error('Media error');
                            break;
                        default:
                            console.error('Unknown error');
                    }
                }
            });
        } else {
            video.src = videoSrc;
        }
    }

    // Initialize player
    initializePlayer();

    // Play/Pause
    playPauseBtn?.addEventListener('click', function() {
        if (video.paused) {
            video.play();
        } else {
            video.pause();
        }
    });

    // Mute/Unmute
    muteUnmuteBtn?.addEventListener('click', function() {
        video.muted = !video.muted;
    });

    // Fullscreen
    fullscreenBtn?.addEventListener('click', function() {
        if (document.fullscreenElement) {
            document.exitFullscreen();
        } else {
            video.requestFullscreen();
        }
    });

    // Update play/pause button icon
    video.addEventListener('play', function() {
        playPauseBtn.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><rect x="6" y="4" width="4" height="16"></rect><rect x="14" y="4" width="4" height="16"></rect></svg>';
    });

    video.addEventListener('pause', function() {
        playPauseBtn.innerHTML = '<svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polygon points="5 3 19 12 5 21 5 3"></polygon></svg>';
    });

    // Update mute button icon
    video.addEventListener('volumechange', function() {
        muteUnmuteBtn.innerHTML = video.muted ? 
            '<svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polygon points="11 5 6 9 2 9 2 15 6 15 11 19 11 5"></polygon><line x1="23" y1="9" x2="17" y2="15"></line><line x1="17" y1="9" x2="23" y2="15"></line></svg>' :
            '<svg xmlns="http://www.w3.org/2000/svg" class="w-6 h-6" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><polygon points="11 5 6 9 2 9 2 15 6 15 11 19 11 5"></polygon><path d="M19.07 4.93a10 10 0 0 1 0 14.14M15.54 8.46a5 5 0 0 1 0 7.07"></path></svg>';
    });
});